/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.sprites;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.google.inject.Inject;
import com.google.inject.Provider;
import technology.rocketjump.undermount.assets.FloorDictionary;
import technology.rocketjump.undermount.assets.RoomEdgeTypeDictionary;
import technology.rocketjump.undermount.assets.TextureAtlasRepository;
import technology.rocketjump.undermount.assets.WallQuadrantDictionary;
import technology.rocketjump.undermount.assets.WallTypeDictionary;
import technology.rocketjump.undermount.mapping.tile.layout.TileLayoutAtlas;
import technology.rocketjump.undermount.sprites.TerrainSpriteCache;

public class NormalTerrainSpriteCacheProvider
implements Provider<TerrainSpriteCache> {
    private final WallTypeDictionary wallTypeDictionary;
    private final FloorDictionary floorDictionary;
    private final WallQuadrantDictionary wallQuadrantDictionary;
    private final TileLayoutAtlas layoutAtlas;
    private final TextureAtlasRepository textureAtlasRepository;
    private final RoomEdgeTypeDictionary roomEdgeTypeDictionary;

    @Inject
    public NormalTerrainSpriteCacheProvider(WallTypeDictionary wallTypeDictionary, FloorDictionary floorDictionary, WallQuadrantDictionary wallQuadrantDictionary, TileLayoutAtlas layoutAtlas, TextureAtlasRepository textureAtlasRepository, RoomEdgeTypeDictionary roomEdgeTypeDictionary) {
        this.wallTypeDictionary = wallTypeDictionary;
        this.floorDictionary = floorDictionary;
        this.wallQuadrantDictionary = wallQuadrantDictionary;
        this.layoutAtlas = layoutAtlas;
        this.textureAtlasRepository = textureAtlasRepository;
        this.roomEdgeTypeDictionary = roomEdgeTypeDictionary;
    }

    @Override
    public TerrainSpriteCache get() {
        TextureAtlas textureAtlas = this.textureAtlasRepository.get(TextureAtlasRepository.TextureAtlasType.NORMAL_TERRAIN);
        return new TerrainSpriteCache(textureAtlas, this.wallTypeDictionary, this.floorDictionary, this.wallQuadrantDictionary, this.layoutAtlas, this.roomEdgeTypeDictionary);
    }
}

